jQuery(function($){

	$("#botonLimpiarCriterios").click(function(){
		fncLimpiarCampos("#divCriteriosBusqueda");
		fncBuscar();
	});
	
	//definición del acordeón de los criterios de búsqueda
	$("#divCriteriosBusqueda").rup_accordion({
		collapsible: true
	});
	
	//popup de edición de eventos del calendario
	$( "#divEditarRegistro" ).rup_dialog({
		autoOpen: false,
	//	height: 300,
		width: 500,
		modal: true,
		resizable: false,
		position: "center",
		type: $.rup.dialog.DIV
	});

	//Añadimos las funciones a los botones 
	$("#botonBuscar").click(fncBuscar);
	//al pulsar intro, que busque
	$("#FORMULARIO").keypress(function(event){
		if (event.which == 13){
			fncBuscar();
		}
	});
	
	$("#botonModificarRegistro").click(modificarRegistro);
	$("#botonAltaRegistro").click(altaRegistro);
	$("#botonGuardarRegistro").click(guardarRegistro);
	$("#botonSalirRegistro").click(cerrarDetalleRegistro);
	
	/* DATA GRID */
	$("#GRID_mantenimiento").rup_grid({
		
		url: "../estadoPeticion/mantenimiento/tabla",
		colNames: [
		    $.rup.i18n.app.GRID_mantenimiento.codEstado,
		    $.rup.i18n.app.GRID_mantenimiento.descEstado,
		    "",
		],
		colModel: [
			{ 	name: "t11CodEstado", 
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "t11DescEstado", 
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "t11IdEstado", 
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			}
        ],
		sortorder: "asc",
		loadOnStartUp: true
	});
	
	/* FORMULARIO */
	$("#FORMULARIO_MANTENIMIENTO").rup_form({
		url:$.rup.CTX_PATH+"estadoPeticion",
		feedback:$("#feedbackMensajesMantenimiento"),
		type: "POST",
		dataType: "json",
		success:function(xhr){
			$("#feedbackMensajesMantenimiento").rup_feedback("set", $.rup.i18n.app.mensajes.ok.datos_guardados_ok, "ok");
			
			var filaArray = $.rup_utils.jsontoarray(xhr);
			$.rup_utils.populateForm(filaArray, $("#FORMULARIO_MANTENIMIENTO"));
			
			fncResetearCambios();
			
			//Recargamos la tabla haciendo la petición al servidor
			$("#GRID_mantenimiento").rup_grid("reloadGrid");
		},
		error: function (xhr, ajaxOptions, thrownError) {
			$("#feedbackMensajesMantenimiento").rup_feedback("set", $.rup.i18n.app.mensajes.error.datos_guardados_error + ", " + xhr.responseText, "error");
		},
		validate:{
			rules:{
				"t11CodEstado":{required:true},
				"t11DescEstado":{required:true}
			}
		}
	});	
	
	fncAplicarGestionCambios("FORMULARIO_MANTENIMIENTO");
	
	//Creamos el área de mensajes dentro del detalle
	$("#feedbackMensajesMantenimiento").rup_feedback({
		type: "ok",
		closeLink: true,
		block: false
	});	
});

function modificarRegistro(){
	//Obtenemos el número de fila seleccionada
	var numFila = $("#GRID_mantenimiento").rup_grid("getGridParam", "selrow");
	if(numFila && numFila>0){
		//Obtenemos los datos de la fila seleccionada
		var filaMantenimiento = $("#GRID_mantenimiento").rup_grid("getRowData",numFila);
		//Limpiamos el formulario
		//$("#FORMULARIO_MANTENIMIENTO").rup_form("clearForm");
		var filaMantenimientoArray = $.rup_utils.jsontoarray(filaMantenimiento);
		$.rup_utils.populateForm(filaMantenimientoArray, $("#FORMULARIO_MANTENIMIENTO"));
		$("#codEstadoDetalle").prop("disabled", true);
		abrirDetalleRegistro();
	}
	else{
		$("#feedbackMensajesMantenimiento").rup_feedback("set", $.rup.i18n.app.mensajes.alert.debe_seleccionar_registro, "alert");
	}
}

/**
 * Función que se llama para mostrar el 
 */
function altaRegistro(){
	//Limpiamos el formulario
	$("#FORMULARIO_MANTENIMIENTO").rup_form("clearForm");
	$("#idRegistro").attr("value","");
	$("#codEstadoDetalle").prop("disabled", false);
	abrirDetalleRegistro();
}

/**
 * Función que llama al controlador para guardar el registro
 */
function guardarRegistro(){
	$("#FORMULARIO_MANTENIMIENTO").submit();
	$( "#divEditarRegistro" ).rup_dialog( "close" );
}

/**
 * Abrir el detalle del registro
 */
function abrirDetalleRegistro(){
	//Eliminamos el dialogo por si tiene iconos de validación de visitas anteriores o mensajes
	fncOcultarValidaciones("#feedbackMensajesMantenimiento");

	$( "#divEditarRegistro" ).rup_dialog( "open" );
}
 
function cerrarDetalleRegistro()
{
	if (fncComprobarSiCambios()){
		fncConfirmarCambios("$( '#divEditarRegistro' ).rup_dialog( 'close' );");
	}else{
		$( "#divEditarRegistro" ).rup_dialog( "close" );
	}
}

/**
 * Función de búsqueda que recarga la tabla y envía los filtros al controller con una
 * petición ajax 
 */
function fncBuscar(){
	varDescripcionEs = $("#descEstado").attr("value");
	varCodEstado = $("#codEstado").attr("value");
	//Construimos el objeto con los parámetros del filtro a enviar

	var filtro = {
			t11DescEstado: varDescripcionEs,
			t11CodEstado: varCodEstado
	};

	//Le pasamos al objeto tabla el filtro
	$("#GRID_mantenimiento").rup_grid("setGridParam",{postData: filtro});
	//Recargamos la tabla haciendo la petición al servidor
	$("#GRID_mantenimiento").rup_grid("reloadGrid");
	
	fncOcultarValidaciones("#feedbackMensajesMantenimiento");
	$("#first_pager").click();
}